/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDefaultPatchBaselineRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, GetDefaultPatchBaselineRequest> {
    private final String operatingSystem;

    private GetDefaultPatchBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.operatingSystem = builder.operatingSystem;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemString() {
        return this.operatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultPatchBaselineRequest)) {
            return false;
        }
        GetDefaultPatchBaselineRequest other = (GetDefaultPatchBaselineRequest)((Object)obj);
        return Objects.equals(this.operatingSystemString(), other.operatingSystemString());
    }

    public String toString() {
        return ToString.builder((String)"GetDefaultPatchBaselineRequest").add("OperatingSystem", (Object)this.operatingSystemString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperatingSystem": {
                return Optional.of(clazz.cast(this.operatingSystemString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultPatchBaselineRequest model) {
            this.operatingSystem(model.operatingSystem);
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetDefaultPatchBaselineRequest build() {
            return new GetDefaultPatchBaselineRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, GetDefaultPatchBaselineRequest> {
        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

