/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.PatchComplianceData;
import software.amazon.awssdk.services.ssm.model.PatchComplianceDataListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancePatchesResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeInstancePatchesResponse> {
    private final List<PatchComplianceData> patches;
    private final String nextToken;

    private DescribeInstancePatchesResponse(BuilderImpl builder) {
        super(builder);
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    public List<PatchComplianceData> patches() {
        return this.patches;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patches());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesResponse)) {
            return false;
        }
        DescribeInstancePatchesResponse other = (DescribeInstancePatchesResponse)((Object)obj);
        return Objects.equals(this.patches(), other.patches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstancePatchesResponse").add("Patches", this.patches()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Patches": {
                return Optional.of(clazz.cast(this.patches()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<PatchComplianceData> patches;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesResponse model) {
            this.patches(model.patches);
            this.nextToken(model.nextToken);
        }

        public final Collection<PatchComplianceData.Builder> getPatches() {
            return this.patches != null ? (Collection)this.patches.stream().map(PatchComplianceData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patches(Collection<PatchComplianceData> patches) {
            this.patches = PatchComplianceDataListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(PatchComplianceData ... patches) {
            this.patches(Arrays.asList(patches));
            return this;
        }

        public final void setPatches(Collection<PatchComplianceData.BuilderImpl> patches) {
            this.patches = PatchComplianceDataListCopier.copyFromBuilder(patches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancePatchesResponse build() {
            return new DescribeInstancePatchesResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeInstancePatchesResponse> {
        public Builder patches(Collection<PatchComplianceData> var1);

        public Builder patches(PatchComplianceData ... var1);

        public Builder nextToken(String var1);
    }
}

