/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.SeveritySummary;
import software.amazon.awssdk.services.ssm.transform.CompliantSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompliantSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, CompliantSummary> {
    private final Integer compliantCount;
    private final SeveritySummary severitySummary;

    private CompliantSummary(BuilderImpl builder) {
        this.compliantCount = builder.compliantCount;
        this.severitySummary = builder.severitySummary;
    }

    public Integer compliantCount() {
        return this.compliantCount;
    }

    public SeveritySummary severitySummary() {
        return this.severitySummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.severitySummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompliantSummary)) {
            return false;
        }
        CompliantSummary other = (CompliantSummary)obj;
        return Objects.equals(this.compliantCount(), other.compliantCount()) && Objects.equals(this.severitySummary(), other.severitySummary());
    }

    public String toString() {
        return ToString.builder((String)"CompliantSummary").add("CompliantCount", (Object)this.compliantCount()).add("SeveritySummary", (Object)this.severitySummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompliantCount": {
                return Optional.of(clazz.cast(this.compliantCount()));
            }
            case "SeveritySummary": {
                return Optional.of(clazz.cast(this.severitySummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompliantSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer compliantCount;
        private SeveritySummary severitySummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CompliantSummary model) {
            this.compliantCount(model.compliantCount);
            this.severitySummary(model.severitySummary);
        }

        public final Integer getCompliantCount() {
            return this.compliantCount;
        }

        @Override
        public final Builder compliantCount(Integer compliantCount) {
            this.compliantCount = compliantCount;
            return this;
        }

        public final void setCompliantCount(Integer compliantCount) {
            this.compliantCount = compliantCount;
        }

        public final SeveritySummary.Builder getSeveritySummary() {
            return this.severitySummary != null ? this.severitySummary.toBuilder() : null;
        }

        @Override
        public final Builder severitySummary(SeveritySummary severitySummary) {
            this.severitySummary = severitySummary;
            return this;
        }

        public final void setSeveritySummary(SeveritySummary.BuilderImpl severitySummary) {
            this.severitySummary = severitySummary != null ? severitySummary.build() : null;
        }

        public CompliantSummary build() {
            return new CompliantSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompliantSummary> {
        public Builder compliantCount(Integer var1);

        public Builder severitySummary(SeveritySummary var1);

        default public Builder severitySummary(Consumer<SeveritySummary.Builder> severitySummary) {
            return this.severitySummary((SeveritySummary)((SeveritySummary.Builder)SeveritySummary.builder().apply(severitySummary)).build());
        }
    }
}

