/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationStatusAggregatedCountCopier;
import software.amazon.awssdk.services.ssm.transform.AssociationOverviewMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociationOverview
implements StructuredPojo,
ToCopyableBuilder<Builder, AssociationOverview> {
    private final String status;
    private final String detailedStatus;
    private final Map<String, Integer> associationStatusAggregatedCount;

    private AssociationOverview(BuilderImpl builder) {
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.associationStatusAggregatedCount = builder.associationStatusAggregatedCount;
    }

    public String status() {
        return this.status;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public Map<String, Integer> associationStatusAggregatedCount() {
        return this.associationStatusAggregatedCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAggregatedCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationOverview)) {
            return false;
        }
        AssociationOverview other = (AssociationOverview)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.detailedStatus(), other.detailedStatus()) && Objects.equals(this.associationStatusAggregatedCount(), other.associationStatusAggregatedCount());
    }

    public String toString() {
        return ToString.builder((String)"AssociationOverview").add("Status", (Object)this.status()).add("DetailedStatus", (Object)this.detailedStatus()).add("AssociationStatusAggregatedCount", this.associationStatusAggregatedCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "DetailedStatus": {
                return Optional.of(clazz.cast(this.detailedStatus()));
            }
            case "AssociationStatusAggregatedCount": {
                return Optional.of(clazz.cast(this.associationStatusAggregatedCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String detailedStatus;
        private Map<String, Integer> associationStatusAggregatedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationOverview model) {
            this.status(model.status);
            this.detailedStatus(model.detailedStatus);
            this.associationStatusAggregatedCount(model.associationStatusAggregatedCount);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Map<String, Integer> getAssociationStatusAggregatedCount() {
            return this.associationStatusAggregatedCount;
        }

        @Override
        public final Builder associationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
            return this;
        }

        public final void setAssociationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
        }

        public AssociationOverview build() {
            return new AssociationOverview(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociationOverview> {
        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder associationStatusAggregatedCount(Map<String, Integer> var1);
    }
}

