/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;

@SdkInternalApi
public class RegisterTaskWithMaintenanceWindowRequestModelMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").build();
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskArn").build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").build();
    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskType").build();
    private static final MarshallingInfo<Map> TASKPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskParameters").build();
    private static final MarshallingInfo<StructuredPojo> TASKINVOCATIONPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskInvocationParameters").build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").build();
    private static final MarshallingInfo<StructuredPojo> LOGGINGINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoggingInfo").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final RegisterTaskWithMaintenanceWindowRequestModelMarshaller INSTANCE = new RegisterTaskWithMaintenanceWindowRequestModelMarshaller();

    public static RegisterTaskWithMaintenanceWindowRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RegisterTaskWithMaintenanceWindowRequest registerTaskWithMaintenanceWindowRequest, ProtocolMarshaller protocolMarshaller) {
        if (registerTaskWithMaintenanceWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.taskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.taskTypeString(), TASKTYPE_BINDING);
            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.taskParameters(), TASKPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.taskInvocationParameters(), TASKINVOCATIONPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.maxConcurrency(), MAXCONCURRENCY_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.maxErrors(), MAXERRORS_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.loggingInfo(), LOGGINGINFO_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.clientToken(), CLIENTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

