/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;

@SdkInternalApi
public class CreateDocumentRequestModelMarshaller {
    private static final MarshallingInfo<String> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").build();
    private static final CreateDocumentRequestModelMarshaller INSTANCE = new CreateDocumentRequestModelMarshaller();

    public static CreateDocumentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDocumentRequest createDocumentRequest, ProtocolMarshaller protocolMarshaller) {
        if (createDocumentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createDocumentRequest.content(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)createDocumentRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createDocumentRequest.documentTypeString(), DOCUMENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

