/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;

public final class GetParametersByPathPaginator
implements SdkIterable<GetParametersByPathResponse> {
    private final SSMClient client;
    private final GetParametersByPathRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetParametersByPathPaginator(SSMClient client, GetParametersByPathRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetParametersByPathResponseFetcher();
    }

    public Iterator<GetParametersByPathResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetParametersByPathResponseFetcher
    implements NextPageFetcher<GetParametersByPathResponse> {
        private GetParametersByPathResponseFetcher() {
        }

        public boolean hasNextPage(GetParametersByPathResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetParametersByPathResponse nextPage(GetParametersByPathResponse previousPage) {
            if (previousPage == null) {
                return GetParametersByPathPaginator.this.client.getParametersByPath(GetParametersByPathPaginator.this.firstRequest);
            }
            return GetParametersByPathPaginator.this.client.getParametersByPath((GetParametersByPathRequest)((Object)GetParametersByPathPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

