/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary;
import software.amazon.awssdk.services.ssm.model.ComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.ComplianceStatus;
import software.amazon.awssdk.services.ssm.model.CompliantSummary;
import software.amazon.awssdk.services.ssm.model.NonCompliantSummary;
import software.amazon.awssdk.services.ssm.transform.ResourceComplianceSummaryItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceComplianceSummaryItem
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceComplianceSummaryItem> {
    private final String complianceType;
    private final String resourceType;
    private final String resourceId;
    private final String status;
    private final String overallSeverity;
    private final ComplianceExecutionSummary executionSummary;
    private final CompliantSummary compliantSummary;
    private final NonCompliantSummary nonCompliantSummary;

    private ResourceComplianceSummaryItem(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.status = builder.status;
        this.overallSeverity = builder.overallSeverity;
        this.executionSummary = builder.executionSummary;
        this.compliantSummary = builder.compliantSummary;
        this.nonCompliantSummary = builder.nonCompliantSummary;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ComplianceStatus status() {
        return ComplianceStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public ComplianceSeverity overallSeverity() {
        return ComplianceSeverity.fromValue(this.overallSeverity);
    }

    public String overallSeverityString() {
        return this.overallSeverity;
    }

    public ComplianceExecutionSummary executionSummary() {
        return this.executionSummary;
    }

    public CompliantSummary compliantSummary() {
        return this.compliantSummary;
    }

    public NonCompliantSummary nonCompliantSummary() {
        return this.nonCompliantSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overallSeverityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceComplianceSummaryItem)) {
            return false;
        }
        ResourceComplianceSummaryItem other = (ResourceComplianceSummaryItem)obj;
        return Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.overallSeverityString(), other.overallSeverityString()) && Objects.equals(this.executionSummary(), other.executionSummary()) && Objects.equals(this.compliantSummary(), other.compliantSummary()) && Objects.equals(this.nonCompliantSummary(), other.nonCompliantSummary());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.complianceType() != null) {
            sb.append("ComplianceType: ").append(this.complianceType()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.overallSeverityString() != null) {
            sb.append("OverallSeverity: ").append(this.overallSeverityString()).append(",");
        }
        if (this.executionSummary() != null) {
            sb.append("ExecutionSummary: ").append(this.executionSummary()).append(",");
        }
        if (this.compliantSummary() != null) {
            sb.append("CompliantSummary: ").append(this.compliantSummary()).append(",");
        }
        if (this.nonCompliantSummary() != null) {
            sb.append("NonCompliantSummary: ").append(this.nonCompliantSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.of(clazz.cast(this.complianceType()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "OverallSeverity": {
                return Optional.of(clazz.cast(this.overallSeverityString()));
            }
            case "ExecutionSummary": {
                return Optional.of(clazz.cast(this.executionSummary()));
            }
            case "CompliantSummary": {
                return Optional.of(clazz.cast(this.compliantSummary()));
            }
            case "NonCompliantSummary": {
                return Optional.of(clazz.cast(this.nonCompliantSummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceComplianceSummaryItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private String resourceType;
        private String resourceId;
        private String status;
        private String overallSeverity;
        private ComplianceExecutionSummary executionSummary;
        private CompliantSummary compliantSummary;
        private NonCompliantSummary nonCompliantSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceComplianceSummaryItem model) {
            this.complianceType(model.complianceType);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.status(model.status);
            this.overallSeverity(model.overallSeverity);
            this.executionSummary(model.executionSummary);
            this.compliantSummary(model.compliantSummary);
            this.nonCompliantSummary(model.nonCompliantSummary);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getOverallSeverity() {
            return this.overallSeverity;
        }

        @Override
        public final Builder overallSeverity(String overallSeverity) {
            this.overallSeverity = overallSeverity;
            return this;
        }

        @Override
        public final Builder overallSeverity(ComplianceSeverity overallSeverity) {
            this.overallSeverity(overallSeverity.toString());
            return this;
        }

        public final void setOverallSeverity(String overallSeverity) {
            this.overallSeverity = overallSeverity;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return this.executionSummary != null ? this.executionSummary.toBuilder() : null;
        }

        @Override
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        public final CompliantSummary.Builder getCompliantSummary() {
            return this.compliantSummary != null ? this.compliantSummary.toBuilder() : null;
        }

        @Override
        public final Builder compliantSummary(CompliantSummary compliantSummary) {
            this.compliantSummary = compliantSummary;
            return this;
        }

        public final void setCompliantSummary(CompliantSummary.BuilderImpl compliantSummary) {
            this.compliantSummary = compliantSummary != null ? compliantSummary.build() : null;
        }

        public final NonCompliantSummary.Builder getNonCompliantSummary() {
            return this.nonCompliantSummary != null ? this.nonCompliantSummary.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantSummary(NonCompliantSummary nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary;
            return this;
        }

        public final void setNonCompliantSummary(NonCompliantSummary.BuilderImpl nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary != null ? nonCompliantSummary.build() : null;
        }

        public ResourceComplianceSummaryItem build() {
            return new ResourceComplianceSummaryItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceComplianceSummaryItem> {
        public Builder complianceType(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder status(String var1);

        public Builder status(ComplianceStatus var1);

        public Builder overallSeverity(String var1);

        public Builder overallSeverity(ComplianceSeverity var1);

        public Builder executionSummary(ComplianceExecutionSummary var1);

        default public Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return this.executionSummary((ComplianceExecutionSummary)((ComplianceExecutionSummary.Builder)ComplianceExecutionSummary.builder().apply(executionSummary)).build());
        }

        public Builder compliantSummary(CompliantSummary var1);

        default public Builder compliantSummary(Consumer<CompliantSummary.Builder> compliantSummary) {
            return this.compliantSummary((CompliantSummary)((CompliantSummary.Builder)CompliantSummary.builder().apply(compliantSummary)).build());
        }

        public Builder nonCompliantSummary(NonCompliantSummary var1);

        default public Builder nonCompliantSummary(Consumer<NonCompliantSummary.Builder> nonCompliantSummary) {
            return this.nonCompliantSummary((NonCompliantSummary)((NonCompliantSummary.Builder)NonCompliantSummary.builder().apply(nonCompliantSummary)).build());
        }
    }
}

