/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.Patch;
import software.amazon.awssdk.services.ssm.model.PatchListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAvailablePatchesResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeAvailablePatchesResponse> {
    private final List<Patch> patches;
    private final String nextToken;

    private DescribeAvailablePatchesResponse(BuilderImpl builder) {
        super(builder);
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    public List<Patch> patches() {
        return this.patches;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patches());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailablePatchesResponse)) {
            return false;
        }
        DescribeAvailablePatchesResponse other = (DescribeAvailablePatchesResponse)((Object)obj);
        return Objects.equals(this.patches(), other.patches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.patches() != null) {
            sb.append("Patches: ").append(this.patches()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Patches": {
                return Optional.of(clazz.cast(this.patches()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<Patch> patches;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailablePatchesResponse model) {
            this.patches(model.patches);
            this.nextToken(model.nextToken);
        }

        public final Collection<Patch.Builder> getPatches() {
            return this.patches != null ? (Collection)this.patches.stream().map(Patch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patches(Collection<Patch> patches) {
            this.patches = PatchListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Patch ... patches) {
            this.patches(Arrays.asList(patches));
            return this;
        }

        public final void setPatches(Collection<Patch.BuilderImpl> patches) {
            this.patches = PatchListCopier.copyFromBuilder(patches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAvailablePatchesResponse build() {
            return new DescribeAvailablePatchesResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeAvailablePatchesResponse> {
        public Builder patches(Collection<Patch> var1);

        public Builder patches(Patch ... var1);

        public Builder nextToken(String var1);
    }
}

