/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadataListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAutomationExecutionsResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeAutomationExecutionsResponse> {
    private final List<AutomationExecutionMetadata> automationExecutionMetadataList;
    private final String nextToken;

    private DescribeAutomationExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.automationExecutionMetadataList = builder.automationExecutionMetadataList;
        this.nextToken = builder.nextToken;
    }

    public List<AutomationExecutionMetadata> automationExecutionMetadataList() {
        return this.automationExecutionMetadataList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionMetadataList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutomationExecutionsResponse)) {
            return false;
        }
        DescribeAutomationExecutionsResponse other = (DescribeAutomationExecutionsResponse)((Object)obj);
        return Objects.equals(this.automationExecutionMetadataList(), other.automationExecutionMetadataList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.automationExecutionMetadataList() != null) {
            sb.append("AutomationExecutionMetadataList: ").append(this.automationExecutionMetadataList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionMetadataList": {
                return Optional.of(clazz.cast(this.automationExecutionMetadataList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<AutomationExecutionMetadata> automationExecutionMetadataList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutomationExecutionsResponse model) {
            this.automationExecutionMetadataList(model.automationExecutionMetadataList);
            this.nextToken(model.nextToken);
        }

        public final Collection<AutomationExecutionMetadata.Builder> getAutomationExecutionMetadataList() {
            return this.automationExecutionMetadataList != null ? (Collection)this.automationExecutionMetadataList.stream().map(AutomationExecutionMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder automationExecutionMetadataList(Collection<AutomationExecutionMetadata> automationExecutionMetadataList) {
            this.automationExecutionMetadataList = AutomationExecutionMetadataListCopier.copy(automationExecutionMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationExecutionMetadataList(AutomationExecutionMetadata ... automationExecutionMetadataList) {
            this.automationExecutionMetadataList(Arrays.asList(automationExecutionMetadataList));
            return this;
        }

        public final void setAutomationExecutionMetadataList(Collection<AutomationExecutionMetadata.BuilderImpl> automationExecutionMetadataList) {
            this.automationExecutionMetadataList = AutomationExecutionMetadataListCopier.copyFromBuilder(automationExecutionMetadataList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutomationExecutionsResponse build() {
            return new DescribeAutomationExecutionsResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeAutomationExecutionsResponse> {
        public Builder automationExecutionMetadataList(Collection<AutomationExecutionMetadata> var1);

        public Builder automationExecutionMetadataList(AutomationExecutionMetadata ... var1);

        public Builder nextToken(String var1);
    }
}

