/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys;
import software.amazon.awssdk.services.ssm.model.StringListCopier;
import software.amazon.awssdk.services.ssm.transform.DescribeActivationsFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeActivationsFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, DescribeActivationsFilter> {
    private final String filterKey;
    private final List<String> filterValues;

    private DescribeActivationsFilter(BuilderImpl builder) {
        this.filterKey = builder.filterKey;
        this.filterValues = builder.filterValues;
    }

    public DescribeActivationsFilterKeys filterKey() {
        return DescribeActivationsFilterKeys.fromValue(this.filterKey);
    }

    public String filterKeyString() {
        return this.filterKey;
    }

    public List<String> filterValues() {
        return this.filterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterKeyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsFilter)) {
            return false;
        }
        DescribeActivationsFilter other = (DescribeActivationsFilter)obj;
        return Objects.equals(this.filterKeyString(), other.filterKeyString()) && Objects.equals(this.filterValues(), other.filterValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filterKeyString() != null) {
            sb.append("FilterKey: ").append(this.filterKeyString()).append(",");
        }
        if (this.filterValues() != null) {
            sb.append("FilterValues: ").append(this.filterValues()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterKey": {
                return Optional.of(clazz.cast(this.filterKeyString()));
            }
            case "FilterValues": {
                return Optional.of(clazz.cast(this.filterValues()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DescribeActivationsFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterKey;
        private List<String> filterValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsFilter model) {
            this.filterKey(model.filterKey);
            this.filterValues(model.filterValues);
        }

        public final String getFilterKey() {
            return this.filterKey;
        }

        @Override
        public final Builder filterKey(String filterKey) {
            this.filterKey = filterKey;
            return this;
        }

        @Override
        public final Builder filterKey(DescribeActivationsFilterKeys filterKey) {
            this.filterKey(filterKey.toString());
            return this;
        }

        public final void setFilterKey(String filterKey) {
            this.filterKey = filterKey;
        }

        public final Collection<String> getFilterValues() {
            return this.filterValues;
        }

        @Override
        public final Builder filterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValues(String ... filterValues) {
            this.filterValues(Arrays.asList(filterValues));
            return this;
        }

        public final void setFilterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
        }

        public DescribeActivationsFilter build() {
            return new DescribeActivationsFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeActivationsFilter> {
        public Builder filterKey(String var1);

        public Builder filterKey(DescribeActivationsFilterKeys var1);

        public Builder filterValues(Collection<String> var1);

        public Builder filterValues(String ... var1);
    }
}

