/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary;
import software.amazon.awssdk.services.ssm.model.ComplianceItemDetailsCopier;
import software.amazon.awssdk.services.ssm.model.ComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.ComplianceStatus;
import software.amazon.awssdk.services.ssm.transform.ComplianceItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceItem
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceItem> {
    private final String complianceType;
    private final String resourceType;
    private final String resourceId;
    private final String id;
    private final String title;
    private final String status;
    private final String severity;
    private final ComplianceExecutionSummary executionSummary;
    private final Map<String, String> details;

    private ComplianceItem(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.id = builder.id;
        this.title = builder.title;
        this.status = builder.status;
        this.severity = builder.severity;
        this.executionSummary = builder.executionSummary;
        this.details = builder.details;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String id() {
        return this.id;
    }

    public String title() {
        return this.title;
    }

    public ComplianceStatus status() {
        return ComplianceStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public ComplianceSeverity severity() {
        return ComplianceSeverity.fromValue(this.severity);
    }

    public String severityString() {
        return this.severity;
    }

    public ComplianceExecutionSummary executionSummary() {
        return this.executionSummary;
    }

    public Map<String, String> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceItem)) {
            return false;
        }
        ComplianceItem other = (ComplianceItem)obj;
        return Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.severityString(), other.severityString()) && Objects.equals(this.executionSummary(), other.executionSummary()) && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.complianceType() != null) {
            sb.append("ComplianceType: ").append(this.complianceType()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.severityString() != null) {
            sb.append("Severity: ").append(this.severityString()).append(",");
        }
        if (this.executionSummary() != null) {
            sb.append("ExecutionSummary: ").append(this.executionSummary()).append(",");
        }
        if (this.details() != null) {
            sb.append("Details: ").append(this.details()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.of(clazz.cast(this.complianceType()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.of(clazz.cast(this.title()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severityString()));
            }
            case "ExecutionSummary": {
                return Optional.of(clazz.cast(this.executionSummary()));
            }
            case "Details": {
                return Optional.of(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private String resourceType;
        private String resourceId;
        private String id;
        private String title;
        private String status;
        private String severity;
        private ComplianceExecutionSummary executionSummary;
        private Map<String, String> details;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceItem model) {
            this.complianceType(model.complianceType);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.id(model.id);
            this.title(model.title);
            this.status(model.status);
            this.severity(model.severity);
            this.executionSummary(model.executionSummary);
            this.details(model.details);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ComplianceSeverity severity) {
            this.severity(severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return this.executionSummary != null ? this.executionSummary.toBuilder() : null;
        }

        @Override
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        public final Map<String, String> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Map<String, String> details) {
            this.details = ComplianceItemDetailsCopier.copy(details);
            return this;
        }

        public final void setDetails(Map<String, String> details) {
            this.details = ComplianceItemDetailsCopier.copy(details);
        }

        public ComplianceItem build() {
            return new ComplianceItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceItem> {
        public Builder complianceType(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder id(String var1);

        public Builder title(String var1);

        public Builder status(String var1);

        public Builder status(ComplianceStatus var1);

        public Builder severity(String var1);

        public Builder severity(ComplianceSeverity var1);

        public Builder executionSummary(ComplianceExecutionSummary var1);

        default public Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return this.executionSummary((ComplianceExecutionSummary)((ComplianceExecutionSummary.Builder)ComplianceExecutionSummary.builder().apply(executionSummary)).build());
        }

        public Builder details(Map<String, String> var1);
    }
}

