/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination;

@SdkInternalApi
public class ResourceDataSyncS3DestinationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Prefix").build();
    private static final MarshallingInfo<String> SYNCFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncFormat").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final MarshallingInfo<String> AWSKMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AWSKMSKeyARN").build();
    private static final ResourceDataSyncS3DestinationMarshaller INSTANCE = new ResourceDataSyncS3DestinationMarshaller();

    public static ResourceDataSyncS3DestinationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceDataSyncS3Destination resourceDataSyncS3Destination, ProtocolMarshaller protocolMarshaller) {
        if (resourceDataSyncS3Destination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceDataSyncS3Destination.bucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncS3Destination.prefix(), PREFIX_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncS3Destination.syncFormatString(), SYNCFORMAT_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncS3Destination.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)resourceDataSyncS3Destination.awskmsKeyARN(), AWSKMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

