/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem;

@SdkInternalApi
public class ComplianceSummaryItemMarshaller {
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").build();
    private static final MarshallingInfo<StructuredPojo> COMPLIANTSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompliantSummary").build();
    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonCompliantSummary").build();
    private static final ComplianceSummaryItemMarshaller INSTANCE = new ComplianceSummaryItemMarshaller();

    public static ComplianceSummaryItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComplianceSummaryItem complianceSummaryItem, ProtocolMarshaller protocolMarshaller) {
        if (complianceSummaryItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)complianceSummaryItem.complianceType(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)complianceSummaryItem.compliantSummary(), COMPLIANTSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)complianceSummaryItem.nonCompliantSummary(), NONCOMPLIANTSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

