/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CommandInvocation;

@SdkInternalApi
public class CommandInvocationMarshaller {
    private static final MarshallingInfo<String> COMMANDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandId").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceName").build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").build();
    private static final MarshallingInfo<Instant> REQUESTEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedDateTime").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").build();
    private static final MarshallingInfo<String> TRACEOUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TraceOutput").build();
    private static final MarshallingInfo<String> STANDARDOUTPUTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardOutputUrl").build();
    private static final MarshallingInfo<String> STANDARDERRORURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardErrorUrl").build();
    private static final MarshallingInfo<List> COMMANDPLUGINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandPlugins").build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationConfig").build();
    private static final CommandInvocationMarshaller INSTANCE = new CommandInvocationMarshaller();

    public static CommandInvocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CommandInvocation commandInvocation, ProtocolMarshaller protocolMarshaller) {
        if (commandInvocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)commandInvocation.commandId(), COMMANDID_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.requestedDateTime(), REQUESTEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.traceOutput(), TRACEOUTPUT_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.standardOutputUrl(), STANDARDOUTPUTURL_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.standardErrorUrl(), STANDARDERRORURL_BINDING);
            protocolMarshaller.marshall(commandInvocation.commandPlugins(), COMMANDPLUGINS_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)commandInvocation.notificationConfig(), NOTIFICATIONCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

