/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AssociationOverview;

@SdkInternalApi
public class AssociationOverviewMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> DETAILEDSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetailedStatus").build();
    private static final MarshallingInfo<Map> ASSOCIATIONSTATUSAGGREGATEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationStatusAggregatedCount").build();
    private static final AssociationOverviewMarshaller INSTANCE = new AssociationOverviewMarshaller();

    public static AssociationOverviewMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociationOverview associationOverview, ProtocolMarshaller protocolMarshaller) {
        if (associationOverview == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)associationOverview.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)associationOverview.detailedStatus(), DETAILEDSTATUS_BINDING);
            protocolMarshaller.marshall(associationOverview.associationStatusAggregatedCount(), ASSOCIATIONSTATUSAGGREGATEDCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

