/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDocumentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDocumentRequest> {
    private final String content;
    private final String name;
    private final String documentVersion;

    private UpdateDocumentRequest(BuilderImpl builder) {
        this.content = builder.content;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
    }

    public String content() {
        return this.content;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentRequest)) {
            return false;
        }
        UpdateDocumentRequest other = (UpdateDocumentRequest)((Object)obj);
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.of(clazz.cast(this.content()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String name;
        private String documentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentRequest model) {
            this.content(model.content);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public UpdateDocumentRequest build() {
            return new UpdateDocumentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDocumentRequest> {
        public Builder content(String var1);

        public Builder name(String var1);

        public Builder documentVersion(String var1);
    }
}

