/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchRule;
import software.amazon.awssdk.services.ssm.model.PatchRuleListCopier;
import software.amazon.awssdk.services.ssm.transform.PatchRuleGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchRuleGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchRuleGroup> {
    private final List<PatchRule> patchRules;

    private PatchRuleGroup(BuilderImpl builder) {
        this.patchRules = builder.patchRules;
    }

    public List<PatchRule> patchRules() {
        return this.patchRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patchRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRuleGroup)) {
            return false;
        }
        PatchRuleGroup other = (PatchRuleGroup)obj;
        return Objects.equals(this.patchRules(), other.patchRules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.patchRules() != null) {
            sb.append("PatchRules: ").append(this.patchRules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchRules": {
                return Optional.of(clazz.cast(this.patchRules()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchRuleGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PatchRule> patchRules;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRuleGroup model) {
            this.patchRules(model.patchRules);
        }

        public final Collection<PatchRule.Builder> getPatchRules() {
            return this.patchRules != null ? (Collection)this.patchRules.stream().map(PatchRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchRules(PatchRule ... patchRules) {
            this.patchRules(Arrays.asList(patchRules));
            return this;
        }

        public final void setPatchRules(Collection<PatchRule.BuilderImpl> patchRules) {
            this.patchRules = PatchRuleListCopier.copyFromBuilder(patchRules);
        }

        public PatchRuleGroup build() {
            return new PatchRuleGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchRuleGroup> {
        public Builder patchRules(Collection<PatchRule> var1);

        public Builder patchRules(PatchRule ... var1);
    }
}

