/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.transform.PatchRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchRule
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchRule> {
    private final PatchFilterGroup patchFilterGroup;
    private final String complianceLevel;
    private final Integer approveAfterDays;

    private PatchRule(BuilderImpl builder) {
        this.patchFilterGroup = builder.patchFilterGroup;
        this.complianceLevel = builder.complianceLevel;
        this.approveAfterDays = builder.approveAfterDays;
    }

    public PatchFilterGroup patchFilterGroup() {
        return this.patchFilterGroup;
    }

    public PatchComplianceLevel complianceLevel() {
        return PatchComplianceLevel.fromValue(this.complianceLevel);
    }

    public String complianceLevelString() {
        return this.complianceLevel;
    }

    public Integer approveAfterDays() {
        return this.approveAfterDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patchFilterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceLevelString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approveAfterDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRule)) {
            return false;
        }
        PatchRule other = (PatchRule)obj;
        return Objects.equals(this.patchFilterGroup(), other.patchFilterGroup()) && Objects.equals(this.complianceLevelString(), other.complianceLevelString()) && Objects.equals(this.approveAfterDays(), other.approveAfterDays());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.patchFilterGroup() != null) {
            sb.append("PatchFilterGroup: ").append(this.patchFilterGroup()).append(",");
        }
        if (this.complianceLevelString() != null) {
            sb.append("ComplianceLevel: ").append(this.complianceLevelString()).append(",");
        }
        if (this.approveAfterDays() != null) {
            sb.append("ApproveAfterDays: ").append(this.approveAfterDays()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchFilterGroup": {
                return Optional.of(clazz.cast(this.patchFilterGroup()));
            }
            case "ComplianceLevel": {
                return Optional.of(clazz.cast(this.complianceLevelString()));
            }
            case "ApproveAfterDays": {
                return Optional.of(clazz.cast(this.approveAfterDays()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private PatchFilterGroup patchFilterGroup;
        private String complianceLevel;
        private Integer approveAfterDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRule model) {
            this.patchFilterGroup(model.patchFilterGroup);
            this.complianceLevel(model.complianceLevel);
            this.approveAfterDays(model.approveAfterDays);
        }

        public final PatchFilterGroup.Builder getPatchFilterGroup() {
            return this.patchFilterGroup != null ? this.patchFilterGroup.toBuilder() : null;
        }

        @Override
        public final Builder patchFilterGroup(PatchFilterGroup patchFilterGroup) {
            this.patchFilterGroup = patchFilterGroup;
            return this;
        }

        public final void setPatchFilterGroup(PatchFilterGroup.BuilderImpl patchFilterGroup) {
            this.patchFilterGroup = patchFilterGroup != null ? patchFilterGroup.build() : null;
        }

        public final String getComplianceLevel() {
            return this.complianceLevel;
        }

        @Override
        public final Builder complianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
            return this;
        }

        @Override
        public final Builder complianceLevel(PatchComplianceLevel complianceLevel) {
            this.complianceLevel(complianceLevel.toString());
            return this;
        }

        public final void setComplianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
        }

        public final Integer getApproveAfterDays() {
            return this.approveAfterDays;
        }

        @Override
        public final Builder approveAfterDays(Integer approveAfterDays) {
            this.approveAfterDays = approveAfterDays;
            return this;
        }

        public final void setApproveAfterDays(Integer approveAfterDays) {
            this.approveAfterDays = approveAfterDays;
        }

        public PatchRule build() {
            return new PatchRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchRule> {
        public Builder patchFilterGroup(PatchFilterGroup var1);

        default public Builder patchFilterGroup(Consumer<PatchFilterGroup.Builder> patchFilterGroup) {
            return this.patchFilterGroup((PatchFilterGroup)((PatchFilterGroup.Builder)PatchFilterGroup.builder().apply(patchFilterGroup)).build());
        }

        public Builder complianceLevel(String var1);

        public Builder complianceLevel(PatchComplianceLevel var1);

        public Builder approveAfterDays(Integer var1);
    }
}

