/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.ParameterHistory;
import software.amazon.awssdk.services.ssm.model.ParameterHistoryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParameterHistoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetParameterHistoryResponse> {
    private final List<ParameterHistory> parameters;
    private final String nextToken;

    private GetParameterHistoryResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.nextToken = builder.nextToken;
    }

    public List<ParameterHistory> parameters() {
        return this.parameters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParameterHistoryResponse)) {
            return false;
        }
        GetParameterHistoryResponse other = (GetParameterHistoryResponse)((Object)obj);
        return Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ParameterHistory> parameters;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParameterHistoryResponse model) {
            this.parameters(model.parameters);
            this.nextToken(model.nextToken);
        }

        public final Collection<ParameterHistory.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(ParameterHistory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<ParameterHistory> parameters) {
            this.parameters = ParameterHistoryListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterHistory ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<ParameterHistory.BuilderImpl> parameters) {
            this.parameters = ParameterHistoryListCopier.copyFromBuilder(parameters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetParameterHistoryResponse build() {
            return new GetParameterHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetParameterHistoryResponse> {
        public Builder parameters(Collection<ParameterHistory> var1);

        public Builder parameters(ParameterHistory ... var1);

        public Builder nextToken(String var1);
    }
}

