/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMaintenanceWindowExecutionTaskInvocationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskInvocationRequest> {
    private final String windowExecutionId;
    private final String taskId;
    private final String invocationId;

    private GetMaintenanceWindowExecutionTaskInvocationRequest(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskId = builder.taskId;
        this.invocationId = builder.invocationId;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskId() {
        return this.taskId;
    }

    public String invocationId() {
        return this.invocationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionTaskInvocationRequest)) {
            return false;
        }
        GetMaintenanceWindowExecutionTaskInvocationRequest other = (GetMaintenanceWindowExecutionTaskInvocationRequest)((Object)obj);
        return Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.invocationId(), other.invocationId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(this.windowExecutionId()).append(",");
        }
        if (this.taskId() != null) {
            sb.append("TaskId: ").append(this.taskId()).append(",");
        }
        if (this.invocationId() != null) {
            sb.append("InvocationId: ").append(this.invocationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.of(clazz.cast(this.windowExecutionId()));
            }
            case "TaskId": {
                return Optional.of(clazz.cast(this.taskId()));
            }
            case "InvocationId": {
                return Optional.of(clazz.cast(this.invocationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskId;
        private String invocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionTaskInvocationRequest model) {
            this.windowExecutionId(model.windowExecutionId);
            this.taskId(model.taskId);
            this.invocationId(model.invocationId);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        public GetMaintenanceWindowExecutionTaskInvocationRequest build() {
            return new GetMaintenanceWindowExecutionTaskInvocationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskInvocationRequest> {
        public Builder windowExecutionId(String var1);

        public Builder taskId(String var1);

        public Builder invocationId(String var1);
    }
}

