/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDocumentPermissionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDocumentPermissionRequest> {
    private final String name;
    private final String permissionType;

    private DescribeDocumentPermissionRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.permissionType = builder.permissionType;
    }

    public String name() {
        return this.name;
    }

    public DocumentPermissionType permissionType() {
        return DocumentPermissionType.fromValue(this.permissionType);
    }

    public String permissionTypeString() {
        return this.permissionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionRequest)) {
            return false;
        }
        DescribeDocumentPermissionRequest other = (DescribeDocumentPermissionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.permissionTypeString(), other.permissionTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.permissionTypeString() != null) {
            sb.append("PermissionType: ").append(this.permissionTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "PermissionType": {
                return Optional.of(clazz.cast(this.permissionTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String permissionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionRequest model) {
            this.name(model.name);
            this.permissionType(model.permissionType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType.toString());
            return this;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        public DescribeDocumentPermissionRequest build() {
            return new DescribeDocumentPermissionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDocumentPermissionRequest> {
        public Builder name(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(DocumentPermissionType var1);
    }
}

