/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ComplianceExecutionSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceExecutionSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceExecutionSummary> {
    private final Instant executionTime;
    private final String executionId;
    private final String executionType;

    private ComplianceExecutionSummary(BuilderImpl builder) {
        this.executionTime = builder.executionTime;
        this.executionId = builder.executionId;
        this.executionType = builder.executionType;
    }

    public Instant executionTime() {
        return this.executionTime;
    }

    public String executionId() {
        return this.executionId;
    }

    public String executionType() {
        return this.executionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceExecutionSummary)) {
            return false;
        }
        ComplianceExecutionSummary other = (ComplianceExecutionSummary)obj;
        return Objects.equals(this.executionTime(), other.executionTime()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.executionType(), other.executionType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.executionTime() != null) {
            sb.append("ExecutionTime: ").append(this.executionTime()).append(",");
        }
        if (this.executionId() != null) {
            sb.append("ExecutionId: ").append(this.executionId()).append(",");
        }
        if (this.executionType() != null) {
            sb.append("ExecutionType: ").append(this.executionType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionTime": {
                return Optional.of(clazz.cast(this.executionTime()));
            }
            case "ExecutionId": {
                return Optional.of(clazz.cast(this.executionId()));
            }
            case "ExecutionType": {
                return Optional.of(clazz.cast(this.executionType()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceExecutionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant executionTime;
        private String executionId;
        private String executionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceExecutionSummary model) {
            this.executionTime(model.executionTime);
            this.executionId(model.executionId);
            this.executionType(model.executionType);
        }

        public final Instant getExecutionTime() {
            return this.executionTime;
        }

        @Override
        public final Builder executionTime(Instant executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(Instant executionTime) {
            this.executionTime = executionTime;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getExecutionType() {
            return this.executionType;
        }

        @Override
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        public ComplianceExecutionSummary build() {
            return new ComplianceExecutionSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceExecutionSummary> {
        public Builder executionTime(Instant var1);

        public Builder executionId(String var1);

        public Builder executionType(String var1);
    }
}

