/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PatchFilterKey {
    PRODUCT("PRODUCT"),
    CLASSIFICATION("CLASSIFICATION"),
    MSRC_SEVERITY("MSRC_SEVERITY"),
    PATCH_ID("PATCH_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PatchFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PatchFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PatchFilterKey.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PatchFilterKey> knownValues() {
        return Stream.of(PatchFilterKey.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

