/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ssm.model.NotificationEvent;
import software.amazon.awssdk.services.ssm.model.NotificationEventListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationType;
import software.amazon.awssdk.services.ssm.transform.NotificationConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NotificationConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, NotificationConfig> {
    private final String notificationArn;
    private final List<String> notificationEvents;
    private final String notificationType;

    private NotificationConfig(BuilderImpl builder) {
        this.notificationArn = builder.notificationArn;
        this.notificationEvents = builder.notificationEvents;
        this.notificationType = builder.notificationType;
    }

    public String notificationArn() {
        return this.notificationArn;
    }

    public List<NotificationEvent> notificationEvents() {
        return TypeConverter.convert(this.notificationEvents, NotificationEvent::fromValue);
    }

    public List<String> notificationEventsStrings() {
        return this.notificationEvents;
    }

    public NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public String notificationTypeString() {
        return this.notificationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.notificationArn() == null ? 0 : this.notificationArn().hashCode());
        hashCode = 31 * hashCode + (this.notificationEventsStrings() == null ? 0 : this.notificationEventsStrings().hashCode());
        hashCode = 31 * hashCode + (this.notificationTypeString() == null ? 0 : this.notificationTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig other = (NotificationConfig)obj;
        if (other.notificationArn() == null ^ this.notificationArn() == null) {
            return false;
        }
        if (other.notificationArn() != null && !other.notificationArn().equals(this.notificationArn())) {
            return false;
        }
        if (other.notificationEventsStrings() == null ^ this.notificationEventsStrings() == null) {
            return false;
        }
        if (other.notificationEventsStrings() != null && !other.notificationEventsStrings().equals(this.notificationEventsStrings())) {
            return false;
        }
        if (other.notificationTypeString() == null ^ this.notificationTypeString() == null) {
            return false;
        }
        return other.notificationTypeString() == null || other.notificationTypeString().equals(this.notificationTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.notificationArn() != null) {
            sb.append("NotificationArn: ").append(this.notificationArn()).append(",");
        }
        if (this.notificationEventsStrings() != null) {
            sb.append("NotificationEvents: ").append(this.notificationEventsStrings()).append(",");
        }
        if (this.notificationTypeString() != null) {
            sb.append("NotificationType: ").append(this.notificationTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationArn": {
                return Optional.of(clazz.cast(this.notificationArn()));
            }
            case "NotificationEvents": {
                return Optional.of(clazz.cast(this.notificationEventsStrings()));
            }
            case "NotificationType": {
                return Optional.of(clazz.cast(this.notificationTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String notificationArn;
        private List<String> notificationEvents;
        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfig model) {
            this.notificationArn(model.notificationArn);
            this.notificationEvents(model.notificationEvents);
            this.notificationType(model.notificationType);
        }

        public final String getNotificationArn() {
            return this.notificationArn;
        }

        @Override
        public final Builder notificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
            return this;
        }

        public final void setNotificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
        }

        public final Collection<String> getNotificationEvents() {
            return this.notificationEvents;
        }

        @Override
        public final Builder notificationEvents(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEvents(String ... notificationEvents) {
            this.notificationEvents(Arrays.asList(notificationEvents));
            return this;
        }

        public final void setNotificationEvents(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public NotificationConfig build() {
            return new NotificationConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NotificationConfig> {
        public Builder notificationArn(String var1);

        public Builder notificationEvents(Collection<String> var1);

        public Builder notificationEvents(String ... var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);
    }
}

