/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowExecutionTaskIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowExecutionTaskIdentity
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowExecutionTaskIdentity> {
    private final String windowExecutionId;
    private final String taskExecutionId;
    private final String status;
    private final String statusDetails;
    private final Instant startTime;
    private final Instant endTime;
    private final String taskArn;
    private final String taskType;

    private MaintenanceWindowExecutionTaskIdentity(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.taskArn = builder.taskArn;
        this.taskType = builder.taskType;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskExecutionId() {
        return this.taskExecutionId;
    }

    public MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(this.taskType);
    }

    public String taskTypeString() {
        return this.taskType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowExecutionId() == null ? 0 : this.windowExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.taskExecutionId() == null ? 0 : this.taskExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.statusDetails() == null ? 0 : this.statusDetails().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.taskArn() == null ? 0 : this.taskArn().hashCode());
        hashCode = 31 * hashCode + (this.taskTypeString() == null ? 0 : this.taskTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowExecutionTaskIdentity)) {
            return false;
        }
        MaintenanceWindowExecutionTaskIdentity other = (MaintenanceWindowExecutionTaskIdentity)obj;
        if (other.windowExecutionId() == null ^ this.windowExecutionId() == null) {
            return false;
        }
        if (other.windowExecutionId() != null && !other.windowExecutionId().equals(this.windowExecutionId())) {
            return false;
        }
        if (other.taskExecutionId() == null ^ this.taskExecutionId() == null) {
            return false;
        }
        if (other.taskExecutionId() != null && !other.taskExecutionId().equals(this.taskExecutionId())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.taskArn() == null ^ this.taskArn() == null) {
            return false;
        }
        if (other.taskArn() != null && !other.taskArn().equals(this.taskArn())) {
            return false;
        }
        if (other.taskTypeString() == null ^ this.taskTypeString() == null) {
            return false;
        }
        return other.taskTypeString() == null || other.taskTypeString().equals(this.taskTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(this.windowExecutionId()).append(",");
        }
        if (this.taskExecutionId() != null) {
            sb.append("TaskExecutionId: ").append(this.taskExecutionId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.taskArn() != null) {
            sb.append("TaskArn: ").append(this.taskArn()).append(",");
        }
        if (this.taskTypeString() != null) {
            sb.append("TaskType: ").append(this.taskTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.of(clazz.cast(this.windowExecutionId()));
            }
            case "TaskExecutionId": {
                return Optional.of(clazz.cast(this.taskExecutionId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "TaskArn": {
                return Optional.of(clazz.cast(this.taskArn()));
            }
            case "TaskType": {
                return Optional.of(clazz.cast(this.taskTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowExecutionTaskIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskExecutionId;
        private String status;
        private String statusDetails;
        private Instant startTime;
        private Instant endTime;
        private String taskArn;
        private String taskType;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowExecutionTaskIdentity model) {
            this.windowExecutionId(model.windowExecutionId);
            this.taskExecutionId(model.taskExecutionId);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.taskArn(model.taskArn);
            this.taskType(model.taskType);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return this.taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public MaintenanceWindowExecutionTaskIdentity build() {
            return new MaintenanceWindowExecutionTaskIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowExecutionTaskIdentity> {
        public Builder windowExecutionId(String var1);

        public Builder taskExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder taskArn(String var1);

        public Builder taskType(String var1);

        public Builder taskType(MaintenanceWindowTaskType var1);
    }
}

