/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.DocumentVersionInfo;
import software.amazon.awssdk.services.ssm.model.DocumentVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDocumentVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDocumentVersionsResponse> {
    private final List<DocumentVersionInfo> documentVersions;
    private final String nextToken;

    private ListDocumentVersionsResponse(BuilderImpl builder) {
        this.documentVersions = builder.documentVersions;
        this.nextToken = builder.nextToken;
    }

    public List<DocumentVersionInfo> documentVersions() {
        return this.documentVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.documentVersions() == null ? 0 : this.documentVersions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentVersionsResponse)) {
            return false;
        }
        ListDocumentVersionsResponse other = (ListDocumentVersionsResponse)((Object)obj);
        if (other.documentVersions() == null ^ this.documentVersions() == null) {
            return false;
        }
        if (other.documentVersions() != null && !other.documentVersions().equals(this.documentVersions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.documentVersions() != null) {
            sb.append("DocumentVersions: ").append(this.documentVersions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentVersions": {
                return Optional.of(clazz.cast(this.documentVersions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DocumentVersionInfo> documentVersions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentVersionsResponse model) {
            this.documentVersions(model.documentVersions);
            this.nextToken(model.nextToken);
        }

        public final Collection<DocumentVersionInfo.Builder> getDocumentVersions() {
            return this.documentVersions != null ? (Collection)this.documentVersions.stream().map(DocumentVersionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentVersions(Collection<DocumentVersionInfo> documentVersions) {
            this.documentVersions = DocumentVersionListCopier.copy(documentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(DocumentVersionInfo ... documentVersions) {
            this.documentVersions(Arrays.asList(documentVersions));
            return this;
        }

        public final void setDocumentVersions(Collection<DocumentVersionInfo.BuilderImpl> documentVersions) {
            this.documentVersions = DocumentVersionListCopier.copyFromBuilder(documentVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDocumentVersionsResponse build() {
            return new ListDocumentVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDocumentVersionsResponse> {
        public Builder documentVersions(Collection<DocumentVersionInfo> var1);

        public Builder documentVersions(DocumentVersionInfo ... var1);

        public Builder nextToken(String var1);
    }
}

