/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InventoryItemAttribute;
import software.amazon.awssdk.services.ssm.model.InventoryItemAttributeListCopier;
import software.amazon.awssdk.services.ssm.transform.InventoryItemSchemaMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryItemSchema
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryItemSchema> {
    private final String typeName;
    private final String version;
    private final List<InventoryItemAttribute> attributes;

    private InventoryItemSchema(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.version = builder.version;
        this.attributes = builder.attributes;
    }

    public String typeName() {
        return this.typeName;
    }

    public String version() {
        return this.version;
    }

    public List<InventoryItemAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeName() == null ? 0 : this.typeName().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryItemSchema)) {
            return false;
        }
        InventoryItemSchema other = (InventoryItemSchema)obj;
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeName() != null) {
            sb.append("TypeName: ").append(this.typeName()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.of(clazz.cast(this.typeName()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryItemSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String version;
        private List<InventoryItemAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryItemSchema model) {
            this.typeName(model.typeName);
            this.version(model.version);
            this.attributes(model.attributes);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<InventoryItemAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(InventoryItemAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<InventoryItemAttribute> attributes) {
            this.attributes = InventoryItemAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(InventoryItemAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<InventoryItemAttribute.BuilderImpl> attributes) {
            this.attributes = InventoryItemAttributeListCopier.copyFromBuilder(attributes);
        }

        public InventoryItemSchema build() {
            return new InventoryItemSchema(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryItemSchema> {
        public Builder typeName(String var1);

        public Builder version(String var1);

        public Builder attributes(Collection<InventoryItemAttribute> var1);

        public Builder attributes(InventoryItemAttribute ... var1);
    }
}

