/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.DocumentDefaultVersionDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentDefaultVersionDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentDefaultVersionDescription> {
    private final String name;
    private final String defaultVersion;

    private DocumentDefaultVersionDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultVersion = builder.defaultVersion;
    }

    public String name() {
        return this.name;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.defaultVersion() == null ? 0 : this.defaultVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDefaultVersionDescription)) {
            return false;
        }
        DocumentDefaultVersionDescription other = (DocumentDefaultVersionDescription)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.defaultVersion() == null ^ this.defaultVersion() == null) {
            return false;
        }
        return other.defaultVersion() == null || other.defaultVersion().equals(this.defaultVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.defaultVersion() != null) {
            sb.append("DefaultVersion: ").append(this.defaultVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DefaultVersion": {
                return Optional.of(clazz.cast(this.defaultVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentDefaultVersionDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String defaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDefaultVersionDescription model) {
            this.name(model.name);
            this.defaultVersion(model.defaultVersion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefaultVersion() {
            return this.defaultVersion;
        }

        @Override
        public final Builder defaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public DocumentDefaultVersionDescription build() {
            return new DocumentDefaultVersionDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentDefaultVersionDescription> {
        public Builder name(String var1);

        public Builder defaultVersion(String var1);
    }
}

