/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.Patch;
import software.amazon.awssdk.services.ssm.model.PatchListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAvailablePatchesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAvailablePatchesResponse> {
    private final List<Patch> patches;
    private final String nextToken;

    private DescribeAvailablePatchesResponse(BuilderImpl builder) {
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    public List<Patch> patches() {
        return this.patches;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.patches() == null ? 0 : this.patches().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailablePatchesResponse)) {
            return false;
        }
        DescribeAvailablePatchesResponse other = (DescribeAvailablePatchesResponse)((Object)obj);
        if (other.patches() == null ^ this.patches() == null) {
            return false;
        }
        if (other.patches() != null && !other.patches().equals(this.patches())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.patches() != null) {
            sb.append("Patches: ").append(this.patches()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Patches": {
                return Optional.of(clazz.cast(this.patches()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Patch> patches;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailablePatchesResponse model) {
            this.patches(model.patches);
            this.nextToken(model.nextToken);
        }

        public final Collection<Patch.Builder> getPatches() {
            return this.patches != null ? (Collection)this.patches.stream().map(Patch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patches(Collection<Patch> patches) {
            this.patches = PatchListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Patch ... patches) {
            this.patches(Arrays.asList(patches));
            return this;
        }

        public final void setPatches(Collection<Patch.BuilderImpl> patches) {
            this.patches = PatchListCopier.copyFromBuilder(patches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAvailablePatchesResponse build() {
            return new DescribeAvailablePatchesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAvailablePatchesResponse> {
        public Builder patches(Collection<Patch> var1);

        public Builder patches(Patch ... var1);

        public Builder nextToken(String var1);
    }
}

