/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity;
import software.amazon.awssdk.services.ssm.transform.PatchGroupPatchBaselineMappingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchGroupPatchBaselineMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchGroupPatchBaselineMapping> {
    private final String patchGroup;
    private final PatchBaselineIdentity baselineIdentity;

    private PatchGroupPatchBaselineMapping(BuilderImpl builder) {
        this.patchGroup = builder.patchGroup;
        this.baselineIdentity = builder.baselineIdentity;
    }

    public String patchGroup() {
        return this.patchGroup;
    }

    public PatchBaselineIdentity baselineIdentity() {
        return this.baselineIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.patchGroup() == null ? 0 : this.patchGroup().hashCode());
        hashCode = 31 * hashCode + (this.baselineIdentity() == null ? 0 : this.baselineIdentity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchGroupPatchBaselineMapping)) {
            return false;
        }
        PatchGroupPatchBaselineMapping other = (PatchGroupPatchBaselineMapping)obj;
        if (other.patchGroup() == null ^ this.patchGroup() == null) {
            return false;
        }
        if (other.patchGroup() != null && !other.patchGroup().equals(this.patchGroup())) {
            return false;
        }
        if (other.baselineIdentity() == null ^ this.baselineIdentity() == null) {
            return false;
        }
        return other.baselineIdentity() == null || other.baselineIdentity().equals(this.baselineIdentity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.patchGroup() != null) {
            sb.append("PatchGroup: ").append(this.patchGroup()).append(",");
        }
        if (this.baselineIdentity() != null) {
            sb.append("BaselineIdentity: ").append(this.baselineIdentity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchGroupPatchBaselineMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String patchGroup;
        private PatchBaselineIdentity baselineIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchGroupPatchBaselineMapping model) {
            this.setPatchGroup(model.patchGroup);
            this.setBaselineIdentity(model.baselineIdentity);
        }

        public final String getPatchGroup() {
            return this.patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final PatchBaselineIdentity getBaselineIdentity() {
            return this.baselineIdentity;
        }

        @Override
        public final Builder baselineIdentity(PatchBaselineIdentity baselineIdentity) {
            this.baselineIdentity = baselineIdentity;
            return this;
        }

        public final void setBaselineIdentity(PatchBaselineIdentity baselineIdentity) {
            this.baselineIdentity = baselineIdentity;
        }

        public PatchGroupPatchBaselineMapping build() {
            return new PatchGroupPatchBaselineMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchGroupPatchBaselineMapping> {
        public Builder patchGroup(String var1);

        public Builder baselineIdentity(PatchBaselineIdentity var1);
    }
}

