/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum Fault {
    Client("Client"),
    Server("Server"),
    Unknown("Unknown");

    private final String value;

    private Fault(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static Fault fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(Fault.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

