/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.StepExecution;

@SdkInternalApi
public class StepExecutionMarshaller {
    private static final MarshallingInfo<String> STEPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepName").build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<Instant> EXECUTIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionStartTime").build();
    private static final MarshallingInfo<Instant> EXECUTIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEndTime").build();
    private static final MarshallingInfo<String> STEPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepStatus").build();
    private static final MarshallingInfo<String> RESPONSECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseCode").build();
    private static final MarshallingInfo<Map> INPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").build();
    private static final MarshallingInfo<Map> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").build();
    private static final MarshallingInfo<String> RESPONSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Response").build();
    private static final MarshallingInfo<String> FAILUREMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureMessage").build();
    private static final MarshallingInfo<StructuredPojo> FAILUREDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureDetails").build();
    private static final StepExecutionMarshaller INSTANCE = new StepExecutionMarshaller();

    public static StepExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepExecution stepExecution, ProtocolMarshaller protocolMarshaller) {
        if (stepExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stepExecution.stepName(), STEPNAME_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.executionStartTime(), EXECUTIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.executionEndTime(), EXECUTIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.stepStatus(), STEPSTATUS_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.responseCode(), RESPONSECODE_BINDING);
            protocolMarshaller.marshall(stepExecution.inputs(), INPUTS_BINDING);
            protocolMarshaller.marshall(stepExecution.outputs(), OUTPUTS_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.response(), RESPONSE_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.failureMessage(), FAILUREMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.failureDetails(), FAILUREDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

