/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.LoggingInfo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParametersCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTaskMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowTask
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowTask> {
    private final String windowId;
    private final String windowTaskId;
    private final String taskArn;
    private final String type;
    private final List<Target> targets;
    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
    private final Integer priority;
    private final LoggingInfo loggingInfo;
    private final String serviceRoleArn;
    private final String maxConcurrency;
    private final String maxErrors;

    private MaintenanceWindowTask(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
        this.taskArn = builder.taskArn;
        this.type = builder.type;
        this.targets = builder.targets;
        this.taskParameters = builder.taskParameters;
        this.priority = builder.priority;
        this.loggingInfo = builder.loggingInfo;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
    }

    public String windowId() {
        return this.windowId;
    }

    public String windowTaskId() {
        return this.windowTaskId;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String type() {
        return this.type;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return this.taskParameters;
    }

    public Integer priority() {
        return this.priority;
    }

    public LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowId() == null ? 0 : this.windowId().hashCode());
        hashCode = 31 * hashCode + (this.windowTaskId() == null ? 0 : this.windowTaskId().hashCode());
        hashCode = 31 * hashCode + (this.taskArn() == null ? 0 : this.taskArn().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        hashCode = 31 * hashCode + (this.taskParameters() == null ? 0 : this.taskParameters().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.loggingInfo() == null ? 0 : this.loggingInfo().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.maxConcurrency() == null ? 0 : this.maxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.maxErrors() == null ? 0 : this.maxErrors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTask)) {
            return false;
        }
        MaintenanceWindowTask other = (MaintenanceWindowTask)obj;
        if (other.windowId() == null ^ this.windowId() == null) {
            return false;
        }
        if (other.windowId() != null && !other.windowId().equals(this.windowId())) {
            return false;
        }
        if (other.windowTaskId() == null ^ this.windowTaskId() == null) {
            return false;
        }
        if (other.windowTaskId() != null && !other.windowTaskId().equals(this.windowTaskId())) {
            return false;
        }
        if (other.taskArn() == null ^ this.taskArn() == null) {
            return false;
        }
        if (other.taskArn() != null && !other.taskArn().equals(this.taskArn())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.taskParameters() == null ^ this.taskParameters() == null) {
            return false;
        }
        if (other.taskParameters() != null && !other.taskParameters().equals(this.taskParameters())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.loggingInfo() == null ^ this.loggingInfo() == null) {
            return false;
        }
        if (other.loggingInfo() != null && !other.loggingInfo().equals(this.loggingInfo())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.maxConcurrency() == null ^ this.maxConcurrency() == null) {
            return false;
        }
        if (other.maxConcurrency() != null && !other.maxConcurrency().equals(this.maxConcurrency())) {
            return false;
        }
        if (other.maxErrors() == null ^ this.maxErrors() == null) {
            return false;
        }
        return other.maxErrors() == null || other.maxErrors().equals(this.maxErrors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.windowId() != null) {
            sb.append("WindowId: ").append(this.windowId()).append(",");
        }
        if (this.windowTaskId() != null) {
            sb.append("WindowTaskId: ").append(this.windowTaskId()).append(",");
        }
        if (this.taskArn() != null) {
            sb.append("TaskArn: ").append(this.taskArn()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.taskParameters() != null) {
            sb.append("TaskParameters: ").append(this.taskParameters()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.loggingInfo() != null) {
            sb.append("LoggingInfo: ").append(this.loggingInfo()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.maxConcurrency()).append(",");
        }
        if (this.maxErrors() != null) {
            sb.append("MaxErrors: ").append(this.maxErrors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTaskId;
        private String taskArn;
        private String type;
        private List<Target> targets;
        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
        private Integer priority;
        private LoggingInfo loggingInfo;
        private String serviceRoleArn;
        private String maxConcurrency;
        private String maxErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTask model) {
            this.setWindowId(model.windowId);
            this.setWindowTaskId(model.windowTaskId);
            this.setTaskArn(model.taskArn);
            this.setType(model.type);
            this.setTargets(model.targets);
            this.setTaskParameters(model.taskParameters);
            this.setPriority(model.priority);
            this.setLoggingInfo(model.loggingInfo);
            this.setServiceRoleArn(model.serviceRoleArn);
            this.setMaxConcurrency(model.maxConcurrency);
            this.setMaxErrors(model.maxErrors);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return this.windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MaintenanceWindowTaskType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Target> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression> getTaskParameters() {
            return this.taskParameters;
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final LoggingInfo getLoggingInfo() {
            return this.loggingInfo;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public MaintenanceWindowTask build() {
            return new MaintenanceWindowTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowTask> {
        public Builder windowId(String var1);

        public Builder windowTaskId(String var1);

        public Builder taskArn(String var1);

        public Builder type(String var1);

        public Builder type(MaintenanceWindowTaskType var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> var1);

        public Builder priority(Integer var1);

        public Builder loggingInfo(LoggingInfo var1);

        public Builder serviceRoleArn(String var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);
    }
}

