/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.model.PatchIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePatchBaselineRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePatchBaselineRequest> {
    private final String name;
    private final PatchFilterGroup globalFilters;
    private final PatchRuleGroup approvalRules;
    private final List<String> approvedPatches;
    private final List<String> rejectedPatches;
    private final String description;
    private final String clientToken;

    private CreatePatchBaselineRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.rejectedPatches = builder.rejectedPatches;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    public String name() {
        return this.name;
    }

    public PatchFilterGroup globalFilters() {
        return this.globalFilters;
    }

    public PatchRuleGroup approvalRules() {
        return this.approvalRules;
    }

    public List<String> approvedPatches() {
        return this.approvedPatches;
    }

    public List<String> rejectedPatches() {
        return this.rejectedPatches;
    }

    public String description() {
        return this.description;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.globalFilters() == null ? 0 : this.globalFilters().hashCode());
        hashCode = 31 * hashCode + (this.approvalRules() == null ? 0 : this.approvalRules().hashCode());
        hashCode = 31 * hashCode + (this.approvedPatches() == null ? 0 : this.approvedPatches().hashCode());
        hashCode = 31 * hashCode + (this.rejectedPatches() == null ? 0 : this.rejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePatchBaselineRequest)) {
            return false;
        }
        CreatePatchBaselineRequest other = (CreatePatchBaselineRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.globalFilters() == null ^ this.globalFilters() == null) {
            return false;
        }
        if (other.globalFilters() != null && !other.globalFilters().equals(this.globalFilters())) {
            return false;
        }
        if (other.approvalRules() == null ^ this.approvalRules() == null) {
            return false;
        }
        if (other.approvalRules() != null && !other.approvalRules().equals(this.approvalRules())) {
            return false;
        }
        if (other.approvedPatches() == null ^ this.approvedPatches() == null) {
            return false;
        }
        if (other.approvedPatches() != null && !other.approvedPatches().equals(this.approvedPatches())) {
            return false;
        }
        if (other.rejectedPatches() == null ^ this.rejectedPatches() == null) {
            return false;
        }
        if (other.rejectedPatches() != null && !other.rejectedPatches().equals(this.rejectedPatches())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        return other.clientToken() == null || other.clientToken().equals(this.clientToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.globalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.globalFilters()).append(",");
        }
        if (this.approvalRules() != null) {
            sb.append("ApprovalRules: ").append(this.approvalRules()).append(",");
        }
        if (this.approvedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.approvedPatches()).append(",");
        }
        if (this.rejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.rejectedPatches()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private PatchFilterGroup globalFilters;
        private PatchRuleGroup approvalRules;
        private List<String> approvedPatches;
        private List<String> rejectedPatches;
        private String description;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePatchBaselineRequest model) {
            this.setName(model.name);
            this.setGlobalFilters(model.globalFilters);
            this.setApprovalRules(model.approvalRules);
            this.setApprovedPatches(model.approvedPatches);
            this.setRejectedPatches(model.rejectedPatches);
            this.setDescription(model.description);
            this.setClientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PatchFilterGroup getGlobalFilters() {
            return this.globalFilters;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
        }

        public final PatchRuleGroup getApprovalRules() {
            return this.approvalRules;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
        }

        public final Collection<String> getApprovedPatches() {
            return this.approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        public final Collection<String> getRejectedPatches() {
            return this.rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public CreatePatchBaselineRequest build() {
            return new CreatePatchBaselineRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePatchBaselineRequest> {
        public Builder name(String var1);

        public Builder globalFilters(PatchFilterGroup var1);

        public Builder approvalRules(PatchRuleGroup var1);

        public Builder approvedPatches(Collection<String> var1);

        public Builder approvedPatches(String ... var1);

        public Builder rejectedPatches(Collection<String> var1);

        public Builder rejectedPatches(String ... var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);
    }
}

