/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget;

@SdkInternalApi
public class MaintenanceWindowTargetMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").build();
    private static final MarshallingInfo<String> WINDOWTARGETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTargetId").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").build();
    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").build();
    private static final MaintenanceWindowTargetMarshaller instance = new MaintenanceWindowTargetMarshaller();

    public static MaintenanceWindowTargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(MaintenanceWindowTarget maintenanceWindowTarget, ProtocolMarshaller protocolMarshaller) {
        if (maintenanceWindowTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.windowTargetId(), WINDOWTARGETID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(maintenanceWindowTarget.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.ownerInformation(), OWNERINFORMATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

