/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.Command;

@SdkInternalApi
public class CommandMarshaller {
    private static final MarshallingInfo<String> COMMANDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandId").build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").build();
    private static final MarshallingInfo<Instant> EXPIRESAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpiresAfter").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<List> INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIds").build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").build();
    private static final MarshallingInfo<Instant> REQUESTEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedDateTime").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").build();
    private static final MarshallingInfo<String> OUTPUTS3REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3Region").build();
    private static final MarshallingInfo<String> OUTPUTS3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3BucketName").build();
    private static final MarshallingInfo<String> OUTPUTS3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3KeyPrefix").build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").build();
    private static final MarshallingInfo<Integer> TARGETCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetCount").build();
    private static final MarshallingInfo<Integer> COMPLETEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedCount").build();
    private static final MarshallingInfo<Integer> ERRORCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCount").build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationConfig").build();
    private static final CommandMarshaller instance = new CommandMarshaller();

    public static CommandMarshaller getInstance() {
        return instance;
    }

    public void marshall(Command command, ProtocolMarshaller protocolMarshaller) {
        if (command == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)command.commandId(), COMMANDID_BINDING);
            protocolMarshaller.marshall((Object)command.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)command.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall((Object)command.expiresAfter(), EXPIRESAFTER_BINDING);
            protocolMarshaller.marshall(command.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(command.instanceIds(), INSTANCEIDS_BINDING);
            protocolMarshaller.marshall(command.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)command.requestedDateTime(), REQUESTEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)command.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)command.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)command.outputS3Region(), OUTPUTS3REGION_BINDING);
            protocolMarshaller.marshall((Object)command.outputS3BucketName(), OUTPUTS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)command.outputS3KeyPrefix(), OUTPUTS3KEYPREFIX_BINDING);
            protocolMarshaller.marshall((Object)command.maxConcurrency(), MAXCONCURRENCY_BINDING);
            protocolMarshaller.marshall((Object)command.maxErrors(), MAXERRORS_BINDING);
            protocolMarshaller.marshall((Object)command.targetCount(), TARGETCOUNT_BINDING);
            protocolMarshaller.marshall((Object)command.completedCount(), COMPLETEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)command.errorCount(), ERRORCOUNT_BINDING);
            protocolMarshaller.marshall((Object)command.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)command.notificationConfig(), NOTIFICATIONCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

