/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchComplianceDataState;
import software.amazon.awssdk.services.ssm.transform.PatchComplianceDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchComplianceData
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchComplianceData> {
    private final String title;
    private final String kbId;
    private final String classification;
    private final String severity;
    private final String state;
    private final Instant installedTime;

    private PatchComplianceData(BuilderImpl builder) {
        this.title = builder.title;
        this.kbId = builder.kbId;
        this.classification = builder.classification;
        this.severity = builder.severity;
        this.state = builder.state;
        this.installedTime = builder.installedTime;
    }

    public String title() {
        return this.title;
    }

    public String kbId() {
        return this.kbId;
    }

    public String classification() {
        return this.classification;
    }

    public String severity() {
        return this.severity;
    }

    public String state() {
        return this.state;
    }

    public Instant installedTime() {
        return this.installedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.title() == null ? 0 : this.title().hashCode());
        hashCode = 31 * hashCode + (this.kbId() == null ? 0 : this.kbId().hashCode());
        hashCode = 31 * hashCode + (this.classification() == null ? 0 : this.classification().hashCode());
        hashCode = 31 * hashCode + (this.severity() == null ? 0 : this.severity().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.installedTime() == null ? 0 : this.installedTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchComplianceData)) {
            return false;
        }
        PatchComplianceData other = (PatchComplianceData)obj;
        if (other.title() == null ^ this.title() == null) {
            return false;
        }
        if (other.title() != null && !other.title().equals(this.title())) {
            return false;
        }
        if (other.kbId() == null ^ this.kbId() == null) {
            return false;
        }
        if (other.kbId() != null && !other.kbId().equals(this.kbId())) {
            return false;
        }
        if (other.classification() == null ^ this.classification() == null) {
            return false;
        }
        if (other.classification() != null && !other.classification().equals(this.classification())) {
            return false;
        }
        if (other.severity() == null ^ this.severity() == null) {
            return false;
        }
        if (other.severity() != null && !other.severity().equals(this.severity())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.installedTime() == null ^ this.installedTime() == null) {
            return false;
        }
        return other.installedTime() == null || other.installedTime().equals(this.installedTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        if (this.kbId() != null) {
            sb.append("KBId: ").append(this.kbId()).append(",");
        }
        if (this.classification() != null) {
            sb.append("Classification: ").append(this.classification()).append(",");
        }
        if (this.severity() != null) {
            sb.append("Severity: ").append(this.severity()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.installedTime() != null) {
            sb.append("InstalledTime: ").append(this.installedTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchComplianceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String title;
        private String kbId;
        private String classification;
        private String severity;
        private String state;
        private Instant installedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchComplianceData model) {
            this.setTitle(model.title);
            this.setKBId(model.kbId);
            this.setClassification(model.classification);
            this.setSeverity(model.severity);
            this.setState(model.state);
            this.setInstalledTime(model.installedTime);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getKBId() {
            return this.kbId;
        }

        @Override
        public final Builder kbId(String kbId) {
            this.kbId = kbId;
            return this;
        }

        public final void setKBId(String kbId) {
            this.kbId = kbId;
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PatchComplianceDataState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(PatchComplianceDataState state) {
            this.state(state.toString());
        }

        public final Instant getInstalledTime() {
            return this.installedTime;
        }

        @Override
        public final Builder installedTime(Instant installedTime) {
            this.installedTime = installedTime;
            return this;
        }

        public final void setInstalledTime(Instant installedTime) {
            this.installedTime = installedTime;
        }

        public PatchComplianceData build() {
            return new PatchComplianceData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchComplianceData> {
        public Builder title(String var1);

        public Builder kbId(String var1);

        public Builder classification(String var1);

        public Builder severity(String var1);

        public Builder state(String var1);

        public Builder state(PatchComplianceDataState var1);

        public Builder installedTime(Instant var1);
    }
}

