/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.AccountIdListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDocumentPermissionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyDocumentPermissionRequest> {
    private final String name;
    private final String permissionType;
    private final List<String> accountIdsToAdd;
    private final List<String> accountIdsToRemove;

    private ModifyDocumentPermissionRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.permissionType = builder.permissionType;
        this.accountIdsToAdd = builder.accountIdsToAdd;
        this.accountIdsToRemove = builder.accountIdsToRemove;
    }

    public String name() {
        return this.name;
    }

    public String permissionType() {
        return this.permissionType;
    }

    public List<String> accountIdsToAdd() {
        return this.accountIdsToAdd;
    }

    public List<String> accountIdsToRemove() {
        return this.accountIdsToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.permissionType() == null ? 0 : this.permissionType().hashCode());
        hashCode = 31 * hashCode + (this.accountIdsToAdd() == null ? 0 : this.accountIdsToAdd().hashCode());
        hashCode = 31 * hashCode + (this.accountIdsToRemove() == null ? 0 : this.accountIdsToRemove().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDocumentPermissionRequest)) {
            return false;
        }
        ModifyDocumentPermissionRequest other = (ModifyDocumentPermissionRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.permissionType() == null ^ this.permissionType() == null) {
            return false;
        }
        if (other.permissionType() != null && !other.permissionType().equals(this.permissionType())) {
            return false;
        }
        if (other.accountIdsToAdd() == null ^ this.accountIdsToAdd() == null) {
            return false;
        }
        if (other.accountIdsToAdd() != null && !other.accountIdsToAdd().equals(this.accountIdsToAdd())) {
            return false;
        }
        if (other.accountIdsToRemove() == null ^ this.accountIdsToRemove() == null) {
            return false;
        }
        return other.accountIdsToRemove() == null || other.accountIdsToRemove().equals(this.accountIdsToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.permissionType() != null) {
            sb.append("PermissionType: ").append(this.permissionType()).append(",");
        }
        if (this.accountIdsToAdd() != null) {
            sb.append("AccountIdsToAdd: ").append(this.accountIdsToAdd()).append(",");
        }
        if (this.accountIdsToRemove() != null) {
            sb.append("AccountIdsToRemove: ").append(this.accountIdsToRemove()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String permissionType;
        private List<String> accountIdsToAdd;
        private List<String> accountIdsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDocumentPermissionRequest model) {
            this.setName(model.name);
            this.setPermissionType(model.permissionType);
            this.setAccountIdsToAdd(model.accountIdsToAdd);
            this.setAccountIdsToRemove(model.accountIdsToRemove);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType.toString());
            return this;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        public final void setPermissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType.toString());
        }

        public final Collection<String> getAccountIdsToAdd() {
            return this.accountIdsToAdd;
        }

        @Override
        public final Builder accountIdsToAdd(Collection<String> accountIdsToAdd) {
            this.accountIdsToAdd = AccountIdListCopier.copy(accountIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdsToAdd(String ... accountIdsToAdd) {
            this.accountIdsToAdd(Arrays.asList(accountIdsToAdd));
            return this;
        }

        public final void setAccountIdsToAdd(Collection<String> accountIdsToAdd) {
            this.accountIdsToAdd = AccountIdListCopier.copy(accountIdsToAdd);
        }

        @SafeVarargs
        public final void setAccountIdsToAdd(String ... accountIdsToAdd) {
            this.accountIdsToAdd(Arrays.asList(accountIdsToAdd));
        }

        public final Collection<String> getAccountIdsToRemove() {
            return this.accountIdsToRemove;
        }

        @Override
        public final Builder accountIdsToRemove(Collection<String> accountIdsToRemove) {
            this.accountIdsToRemove = AccountIdListCopier.copy(accountIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdsToRemove(String ... accountIdsToRemove) {
            this.accountIdsToRemove(Arrays.asList(accountIdsToRemove));
            return this;
        }

        public final void setAccountIdsToRemove(Collection<String> accountIdsToRemove) {
            this.accountIdsToRemove = AccountIdListCopier.copy(accountIdsToRemove);
        }

        @SafeVarargs
        public final void setAccountIdsToRemove(String ... accountIdsToRemove) {
            this.accountIdsToRemove(Arrays.asList(accountIdsToRemove));
        }

        public ModifyDocumentPermissionRequest build() {
            return new ModifyDocumentPermissionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyDocumentPermissionRequest> {
        public Builder name(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(DocumentPermissionType var1);

        public Builder accountIdsToAdd(Collection<String> var1);

        public Builder accountIdsToAdd(String ... var1);

        public Builder accountIdsToRemove(Collection<String> var1);

        public Builder accountIdsToRemove(String ... var1);
    }
}

