/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.services.ssm.model.CommandListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCommandsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCommandsResponse> {
    private final List<Command> commands;
    private final String nextToken;

    private ListCommandsResponse(BuilderImpl builder) {
        this.commands = builder.commands;
        this.nextToken = builder.nextToken;
    }

    public List<Command> commands() {
        return this.commands;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.commands() == null ? 0 : this.commands().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsResponse)) {
            return false;
        }
        ListCommandsResponse other = (ListCommandsResponse)((Object)obj);
        if (other.commands() == null ^ this.commands() == null) {
            return false;
        }
        if (other.commands() != null && !other.commands().equals(this.commands())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commands() != null) {
            sb.append("Commands: ").append(this.commands()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Command> commands;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandsResponse model) {
            this.setCommands(model.commands);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Command> getCommands() {
            return this.commands;
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandListCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command ... commands) {
            this.commands(Arrays.asList(commands));
            return this;
        }

        public final void setCommands(Collection<Command> commands) {
            this.commands = CommandListCopier.copy(commands);
        }

        @SafeVarargs
        public final void setCommands(Command ... commands) {
            this.commands(Arrays.asList(commands));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListCommandsResponse build() {
            return new ListCommandsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCommandsResponse> {
        public Builder commands(Collection<Command> var1);

        public Builder commands(Command ... var1);

        public Builder nextToken(String var1);
    }
}

