/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.CommandFilter;
import software.amazon.awssdk.services.ssm.model.CommandFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCommandsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListCommandsRequest> {
    private final String commandId;
    private final String instanceId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<CommandFilter> filters;

    private ListCommandsRequest(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    public String commandId() {
        return this.commandId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<CommandFilter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.commandId() == null ? 0 : this.commandId().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsRequest)) {
            return false;
        }
        ListCommandsRequest other = (ListCommandsRequest)((Object)obj);
        if (other.commandId() == null ^ this.commandId() == null) {
            return false;
        }
        if (other.commandId() != null && !other.commandId().equals(this.commandId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        return other.filters() == null || other.filters().equals(this.filters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commandId() != null) {
            sb.append("CommandId: ").append(this.commandId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String commandId;
        private String instanceId;
        private Integer maxResults;
        private String nextToken;
        private List<CommandFilter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandsRequest model) {
            this.setCommandId(model.commandId);
            this.setInstanceId(model.instanceId);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setFilters(model.filters);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CommandFilter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<CommandFilter> filters) {
            this.filters = CommandFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(CommandFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<CommandFilter> filters) {
            this.filters = CommandFilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(CommandFilter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public ListCommandsRequest build() {
            return new ListCommandsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCommandsRequest> {
        public Builder commandId(String var1);

        public Builder instanceId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder filters(Collection<CommandFilter> var1);

        public Builder filters(CommandFilter ... var1);
    }
}

