/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.AssociationFilter;
import software.amazon.awssdk.services.ssm.model.AssociationFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAssociationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListAssociationsRequest> {
    private final List<AssociationFilter> associationFilterList;
    private final Integer maxResults;
    private final String nextToken;

    private ListAssociationsRequest(BuilderImpl builder) {
        this.associationFilterList = builder.associationFilterList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<AssociationFilter> associationFilterList() {
        return this.associationFilterList;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associationFilterList() == null ? 0 : this.associationFilterList().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsRequest)) {
            return false;
        }
        ListAssociationsRequest other = (ListAssociationsRequest)((Object)obj);
        if (other.associationFilterList() == null ^ this.associationFilterList() == null) {
            return false;
        }
        if (other.associationFilterList() != null && !other.associationFilterList().equals(this.associationFilterList())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.associationFilterList() != null) {
            sb.append("AssociationFilterList: ").append(this.associationFilterList()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AssociationFilter> associationFilterList;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationsRequest model) {
            this.setAssociationFilterList(model.associationFilterList);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<AssociationFilter> getAssociationFilterList() {
            return this.associationFilterList;
        }

        @Override
        public final Builder associationFilterList(Collection<AssociationFilter> associationFilterList) {
            this.associationFilterList = AssociationFilterListCopier.copy(associationFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationFilterList(AssociationFilter ... associationFilterList) {
            this.associationFilterList(Arrays.asList(associationFilterList));
            return this;
        }

        public final void setAssociationFilterList(Collection<AssociationFilter> associationFilterList) {
            this.associationFilterList = AssociationFilterListCopier.copy(associationFilterList);
        }

        @SafeVarargs
        public final void setAssociationFilterList(AssociationFilter ... associationFilterList) {
            this.associationFilterList(Arrays.asList(associationFilterList));
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListAssociationsRequest build() {
            return new ListAssociationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAssociationsRequest> {
        public Builder associationFilterList(Collection<AssociationFilter> var1);

        public Builder associationFilterList(AssociationFilter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

