/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType;
import software.amazon.awssdk.services.ssm.transform.InventoryItemAttributeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryItemAttribute
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryItemAttribute> {
    private final String name;
    private final String dataType;

    private InventoryItemAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
    }

    public String name() {
        return this.name;
    }

    public String dataType() {
        return this.dataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.dataType() == null ? 0 : this.dataType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryItemAttribute)) {
            return false;
        }
        InventoryItemAttribute other = (InventoryItemAttribute)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.dataType() == null ^ this.dataType() == null) {
            return false;
        }
        return other.dataType() == null || other.dataType().equals(this.dataType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.dataType() != null) {
            sb.append("DataType: ").append(this.dataType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryItemAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryItemAttribute model) {
            this.setName(model.name);
            this.setDataType(model.dataType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(InventoryAttributeDataType dataType) {
            this.dataType(dataType.toString());
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final void setDataType(InventoryAttributeDataType dataType) {
            this.dataType(dataType.toString());
        }

        public InventoryItemAttribute build() {
            return new InventoryItemAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryItemAttribute> {
        public Builder name(String var1);

        public Builder dataType(String var1);

        public Builder dataType(InventoryAttributeDataType var1);
    }
}

