/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.Patch;
import software.amazon.awssdk.services.ssm.model.PatchStatus;
import software.amazon.awssdk.services.ssm.transform.EffectivePatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EffectivePatch
implements StructuredPojo,
ToCopyableBuilder<Builder, EffectivePatch> {
    private final Patch patch;
    private final PatchStatus patchStatus;

    private EffectivePatch(BuilderImpl builder) {
        this.patch = builder.patch;
        this.patchStatus = builder.patchStatus;
    }

    public Patch patch() {
        return this.patch;
    }

    public PatchStatus patchStatus() {
        return this.patchStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.patch() == null ? 0 : this.patch().hashCode());
        hashCode = 31 * hashCode + (this.patchStatus() == null ? 0 : this.patchStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectivePatch)) {
            return false;
        }
        EffectivePatch other = (EffectivePatch)obj;
        if (other.patch() == null ^ this.patch() == null) {
            return false;
        }
        if (other.patch() != null && !other.patch().equals(this.patch())) {
            return false;
        }
        if (other.patchStatus() == null ^ this.patchStatus() == null) {
            return false;
        }
        return other.patchStatus() == null || other.patchStatus().equals(this.patchStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.patch() != null) {
            sb.append("Patch: ").append(this.patch()).append(",");
        }
        if (this.patchStatus() != null) {
            sb.append("PatchStatus: ").append(this.patchStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EffectivePatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Patch patch;
        private PatchStatus patchStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectivePatch model) {
            this.setPatch(model.patch);
            this.setPatchStatus(model.patchStatus);
        }

        public final Patch getPatch() {
            return this.patch;
        }

        @Override
        public final Builder patch(Patch patch) {
            this.patch = patch;
            return this;
        }

        public final void setPatch(Patch patch) {
            this.patch = patch;
        }

        public final PatchStatus getPatchStatus() {
            return this.patchStatus;
        }

        @Override
        public final Builder patchStatus(PatchStatus patchStatus) {
            this.patchStatus = patchStatus;
            return this;
        }

        public final void setPatchStatus(PatchStatus patchStatus) {
            this.patchStatus = patchStatus;
        }

        public EffectivePatch build() {
            return new EffectivePatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EffectivePatch> {
        public Builder patch(Patch var1);

        public Builder patchStatus(PatchStatus var1);
    }
}

