/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.SeveritySummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SeveritySummaryMarshaller {
    private static final MarshallingInfo<Integer> CRITICALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CriticalCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> HIGHCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HighCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> MEDIUMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediumCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> LOWCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LowCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> INFORMATIONALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InformationalCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> UNSPECIFIEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnspecifiedCount").isBinary(false).build();
    private static final SeveritySummaryMarshaller INSTANCE = new SeveritySummaryMarshaller();

    private SeveritySummaryMarshaller() {
    }

    public static SeveritySummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SeveritySummary severitySummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)severitySummary, (String)"severitySummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)severitySummary.criticalCount(), CRITICALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.highCount(), HIGHCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.mediumCount(), MEDIUMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.lowCount(), LOWCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.informationalCount(), INFORMATIONALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.unspecifiedCount(), UNSPECIFIEDCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

