/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.SendCommandRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SendCommandRequestModelMarshaller {
    private static final MarshallingInfo<List> INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIds").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentHash").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTHASHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentHashType").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUTSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeoutSeconds").isBinary(false).build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3Region").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3BucketName").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3KeyPrefix").isBinary(false).build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").isBinary(false).build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationConfig").isBinary(false).build();
    private static final SendCommandRequestModelMarshaller INSTANCE = new SendCommandRequestModelMarshaller();

    private SendCommandRequestModelMarshaller() {
    }

    public static SendCommandRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SendCommandRequest sendCommandRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)sendCommandRequest), (String)"sendCommandRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(sendCommandRequest.instanceIds(), INSTANCEIDS_BINDING);
            protocolMarshaller.marshall(sendCommandRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.documentHash(), DOCUMENTHASH_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.documentHashTypeAsString(), DOCUMENTHASHTYPE_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.timeoutSeconds(), TIMEOUTSECONDS_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall(sendCommandRequest.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.outputS3Region(), OUTPUTS3REGION_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.outputS3BucketName(), OUTPUTS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.outputS3KeyPrefix(), OUTPUTS3KEYPREFIX_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.maxConcurrency(), MAXCONCURRENCY_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.maxErrors(), MAXERRORS_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)sendCommandRequest.notificationConfig(), NOTIFICATIONCONFIG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

