/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RemoveTagsFromResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<List> TAGKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKeys").isBinary(false).build();
    private static final RemoveTagsFromResourceRequestModelMarshaller INSTANCE = new RemoveTagsFromResourceRequestModelMarshaller();

    private RemoveTagsFromResourceRequestModelMarshaller() {
    }

    public static RemoveTagsFromResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RemoveTagsFromResourceRequest removeTagsFromResourceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)removeTagsFromResourceRequest), (String)"removeTagsFromResourceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)removeTagsFromResourceRequest.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)removeTagsFromResourceRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(removeTagsFromResourceRequest.tagKeys(), TAGKEYS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

