/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RegisterTaskWithMaintenanceWindowRequestModelMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskArn").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskType").isBinary(false).build();
    private static final MarshallingInfo<Map> TASKPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskParameters").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TASKINVOCATIONPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskInvocationParameters").isBinary(false).build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").isBinary(false).build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").isBinary(false).build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOGGINGINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoggingInfo").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final RegisterTaskWithMaintenanceWindowRequestModelMarshaller INSTANCE = new RegisterTaskWithMaintenanceWindowRequestModelMarshaller();

    private RegisterTaskWithMaintenanceWindowRequestModelMarshaller() {
    }

    public static RegisterTaskWithMaintenanceWindowRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RegisterTaskWithMaintenanceWindowRequest registerTaskWithMaintenanceWindowRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)registerTaskWithMaintenanceWindowRequest), (String)"registerTaskWithMaintenanceWindowRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.taskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.taskTypeAsString(), TASKTYPE_BINDING);
            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.taskParameters(), TASKPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.taskInvocationParameters(), TASKINVOCATIONPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.maxConcurrency(), MAXCONCURRENCY_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.maxErrors(), MAXERRORS_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.loggingInfo(), LOGGINGINFO_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)registerTaskWithMaintenanceWindowRequest.clientToken(), CLIENTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

