/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListCommandsRequestModelMarshaller {
    private static final MarshallingInfo<String> COMMANDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final ListCommandsRequestModelMarshaller INSTANCE = new ListCommandsRequestModelMarshaller();

    private ListCommandsRequestModelMarshaller() {
    }

    public static ListCommandsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListCommandsRequest listCommandsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listCommandsRequest), (String)"listCommandsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listCommandsRequest.commandId(), COMMANDID_BINDING);
            protocolMarshaller.marshall((Object)listCommandsRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)listCommandsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listCommandsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(listCommandsRequest.filters(), FILTERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

