/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListAssociationsRequestModelMarshaller {
    private static final MarshallingInfo<List> ASSOCIATIONFILTERLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationFilterList").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final ListAssociationsRequestModelMarshaller INSTANCE = new ListAssociationsRequestModelMarshaller();

    private ListAssociationsRequestModelMarshaller() {
    }

    public static ListAssociationsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListAssociationsRequest listAssociationsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listAssociationsRequest), (String)"listAssociationsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(listAssociationsRequest.associationFilterList(), ASSOCIATIONFILTERLIST_BINDING);
            protocolMarshaller.marshall((Object)listAssociationsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listAssociationsRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

